/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.validation;

import cz.insophy.inplan.util.problems.Problem;
import java.util.Collections;
import java.util.List;

public class ValidationResult {
    private final PlanValidity validity;
    private final List<Problem> results;

    public ValidationResult(List<Problem> results) {
        this.results = Collections.unmodifiableList(results);
        PlanValidity valid = PlanValidity.VALID;
        for (Problem vr : results) {
            if (vr.getLevel() == Problem.Level.ERROR) {
                this.validity = valid = PlanValidity.ERROR;
                return;
            }
            if (vr.getLevel() != Problem.Level.WARNING) continue;
            valid = PlanValidity.WARNING;
        }
        this.validity = valid;
    }

    public ValidationResult() {
        this(Collections.emptyList());
    }

    public PlanValidity getValidity() {
        return this.validity;
    }

    public boolean isValid() {
        return this.validity != PlanValidity.ERROR;
    }

    public List<Problem> getResults() {
        return this.results;
    }

    public String toString() {
        return String.format("ValidationResults(%s, %s)", new Object[]{this.validity, this.results});
    }

    public static enum PlanValidity {
        VALID,
        WARNING,
        ERROR;

    }
}

